﻿using System;
using System.Linq;
using VA.TMP.DataModel;
using VA.TMP.Integration.VIMT.HealthShare.StateObject;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.HealthShare.PipelineSteps.MakeCancelOutbound
{
    /// <summary>
    /// Get Appointments Step.
    /// </summary>
    public class GetAppointmentStep : FilterBase<MakeCancelOutboundStateObject>
    {
        /// <summary>
        /// Execute the step.
        /// </summary>
        /// <param name="state">State object.</param>
        public override void Execute(MakeCancelOutboundStateObject state)
        {
            if (!state.IsGroupAppointment) return;

            if (!state.AppointmentId.HasValue || state.AppointmentId.Value == Guid.Empty) throw new Exception("Group Appointment must have a valid AppointmentId");

            using (var srv = new Xrm(state.OrganizationServiceProxy))
            {
                state.Appointment = srv.AppointmentSet.FirstOrDefault(x => x.Id == state.AppointmentId.Value);
                if (state.Appointment == null) throw new Exception($"Cannot find Appointment: {state.AppointmentId.Value} required for a Group Appointment");
            }
        }
    }
}